﻿$User = $env:USERNAME
$ModuleExist = $false
$Admins = Get-LocalGroupMember -Group Administrators
if ($Null -eq $($Admins.Name -like "*$User")) {
    Write-Host "Current User is Not an Administrator of this Machine."
    Write-Host "Administrator rights are required to install modules. Log on to the computer with an account that has Administrator rights, and then try again."
    Write-Host "You can also try running the Windows PowerShell session with elevated rights (Run as Administrator)."
    pause
    } else {
    if (Get-Module -ListAvailable -Name ExchangeOnlineManagement) {
        $ModuleExist = $true
        write-host "Module exist"
        pause
    } else {
    write-Host "Module ExchangeOnlineManagement not exist"
    Write-Host "Checking internet connection..."
    if (Test-Connection 8.8.8.8 -Count 1 -ErrorAction SilentlyContinue) {
         Write-Host "Valid Internet Connection"
         DO {
            $confirmation = Read-Host "Do you want install ExchangeOnlineManagement Module? [Y/N]"
            if ($confirmation -eq 'y') {
                Write-Host "Required modules setup in progress..."
                # Use TLS1.2 if needed
		# [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
		Install-Module ExchangeOnlineManagement -Scope CurrentUser
                if (Get-Module -ListAvailable -Name ExchangeOnlineManagement) {
                    $ModuleExist = $true
                    write-host "Module installated"
                    pause
                } else {
                Write-Host "Try to reinstall module"
                pause
            }
            }
         } While (($confirmation -ne 'y') -and ($confirmation -ne 'n'))
    } else {
        Write-Host "No Internet Connection."
        pause
    }
    }
}
