# Software version must be 2.x because of server requirements
$VERSION = "2.05"

$ConfigFilePath=$args[0]
$FileName = "config.json"

function validate_config([string]$config_file) {
  if (Test-Path -Path $ConfigFilePath\$FileName) {
    $ConfigText = Get-Content -path $ConfigFilePath\$FileName -Raw
     try {
       $TestJson = ConvertFrom-Json $ConfigText -ErrorAction Stop;
       $ValidJson = $true;
     } catch {
       $ValidJson = $false;
     }
     if ($ValidJson) {
      $Config = Get-Content -path $ConfigFilePath\$FileName | ConvertFrom-Json
      <#
      if ($msp_submit -eq 1) {
        $Config.token
        $Config.uri
      } else {
        $Config.msp_token
        $Config.uri
      }
      #>
      return $Config
     } else {
       return "Config.Json is not a valid JSON string";
     }
  } else {
    Write-Host "File config.json not found"
    Write-Host $ConfigFilePath
  }
}

function get_mso_json {
    Param
    (
         [Parameter(Mandatory=$true, Position=0)]
         [object] $version,
         [Parameter(Mandatory=$true, Position=1)]
         [object] $config
    )

  $pre_json = '{
     "version" : "' + $version + '",
     "accounts" : [ '
  $post_json = ' ]
  }'

  try {
     if($config.mfa -eq $true) {
       Connect-ExchangeOnline -ErrorAction Stop
     } else {
       if(Test-Path credentials.xml) {
         $cred = Import-CliXml -Path credentials.xml
       } else {
         $cred = Get-Credential
         $cred | Export-CliXml -Path credentials.xml
       }
       Connect-ExchangeOnline -Credential $cred -ErrorAction Stop
     }
     $ValidCredential = $true
  }
  catch {
     $ValidCredential = $false
  }
  if ($ValidCredential) {
   # Get-MsolCompanyInformation | Select-Object DisplayName
   # $users = Get-MsolUser | Where-Object {$_.isLicensed -eq 'True'} | select-object Displayname, UserPrincipalName, ProxyAddresses
   $users = Get-EXOMailBox | select-object Displayname, UserPrincipalName, EmailAddresses
   $json = $pre_json
   $cnt = 1
   foreach ($val in $users) {
     $userdname = $val.DisplayName
     $json += '{';
     $json += "`r`n"
     $json += '"primary_email" : "' + $val.UserPrincipalName + '",'
     $json += "`r`n"
     $json += '"name" : "' + $userdname.Replace('"', '\"') + '",'
     $json += "`r`n"
     $json += '"emails" : ['
     $json += "`r`n"
     #$json += '"' + $val.UserPrincipalName + '"'
     #$json += "`r`n"
     if($val.PSObject.Properties.name -match "EmailAddresses") {
       foreach ($tmpval in ($val.EmailAddresses -split(" "))) {
         if($tmpval -match '^smtp:') {
           $tmpval = '"' + $tmpval.Replace('smtp:','').Replace('SMTP:','') + '",'
           $tmpjson += $tmpval
           $tmpval = ""
         }
       }
       $tmpjson = $tmpjson.TrimEnd(',')
       $json += $tmpjson
       $tmpjson = ""
     }
     $json += "`r`n"
     $json += '],'
     $json += "`r`n"
     $json += '"cont_user" : "' + $val.UserPrincipalName + '",'
     $json += "`r`n"
     $json += '"username" : "' + $val.UserPrincipalName + '"'
     $json += "`r`n"
     $json += '}'
     if($users.count -ne $cnt) {
       $json += ','
     }
     $json += "`r`n"
     $cnt++
     $userdname = ""
   }
   $dgroups = Get-DistributionGroup | select-object Displayname, Alias, PrimarySmtpAddress, EmailAddresses
   $cnt = 1;
   # XXX $dgroups.count doesn't work
   foreach ($val in $dgroups) {
     $totgroup++
   }
   foreach ($val in $dgroups) {
     if($cnt -eq 1) {
       $json += ','
       $json += "`r`n"
     }
     $userdname = $val.DisplayName
     $json += '{';
     $json += "`r`n"
     $json += '"primary_email" : "' + $val.PrimarySmtpAddress + '",'
     $json += "`r`n"
     $json += '"name" : "' + $userdname.Replace('"', '\"') + '",'
     $json += "`r`n"
     $json += '"emails" : ['
     $json += "`r`n"
     #$json += '"' + $val.UserPrincipalName + '"'
     #$json += "`r`n"
     if($val.PSObject.Properties.name -match "EmailAddresses") {
       foreach ($tmpval in ($val.EmailAddresses -split(" "))) {
         if($tmpval -match '^smtp:') {
           $tmpval = '"' + $tmpval.Replace('smtp:','').Replace('SMTP:','') + '",'
           $tmpjson += $tmpval
           $tmpval = ""
         }
       }
       $tmpjson = $tmpjson.TrimEnd(',')
       $json += $tmpjson
       $tmpjson = ""
     }
     $json += "`r`n"
     $json += '],'
     $json += "`r`n"
     $json += '"cont_user" : "' + $val.Alias + '",'
     $json += "`r`n"
     $json += '"username" : "' + $val.Alias + '"'
     $json += "`r`n"
     $json += '}'
     if($totgroup -ne $cnt) {
       $json += ','
     }
     $json += "`r`n"
     $cnt++
     $userdname = ""
   }
  } else {
    return $null
  }
  $json += $post_json
  return $json
}

$config = validate_config($FileName)
if($config.uri -ne $null) {
  
  $json = get_mso_json $version $config
  if ($json -ne $null) {
    # Connect to Raptor
    if ($Config.token -ne $null) {
      $body = @{
        "version" = $VERSION
        "json_request" = $json
        "token" = $Config.token
      }
    } elseif ($Config.msp_token -ne $null) {
      $body = @{
        "version" = $VERSION
        "json_request" = $json
        "token" = $Config.msp_token
      }
    }
    $resp = Invoke-WebRequest -Method Post -Uri $Config.uri -Body $body
    Write-Host $resp
    # $jbody = $body | ConvertTo-Json
    # Write-Host $jbody
    Write-Host $json
    pause
  } else {
    write-host "Username or Password is incorrect"
    pause
  }
} else {
  Write-Host $config
  pause
}

